#include "MojeOkno.h"
#include "Varia.h" //JednostkowyWektorNormalny3fv
#include "Modele.h" //Rysuj...
//#include "glext.h"
#include "resource.h"

//#include "UkladyPunktowMaterialnych.h"
//#include "UkladyPunktowMaterialnych2.h"

#define _USE_MATH_DEFINES
#include <cmath>

#include "UkladyBrylSztywnych.h"

CMojeOknoGL::CMojeOknoGL()
:COknoGL(),zbs(NULL),
algorytm(algorytmEulera),krokCzasowy(0.1),iloscKrokowWSerii(1),
//pauza(false),
typRzutowania(false)
{			
	zbs=new ZbiorProstopadloscianow(5,1,0.5,1.5,1);

	#ifdef _DEBUG
	if(zbs==NULL) MessageBox(uchwytOkna,"Brak zbioru punktw materialnych","Debug info",MB_OK);
	#endif
}

CMojeOknoGL::~CMojeOknoGL()
{
	delete zbs;
	zbs=NULL;
}

void CMojeOknoGL::RysujZbiorProstopadloscianow(ZbiorProstopadloscianow* zp,const double jednostkaDlugosci,bool koloruj) const
{
	if(zp==NULL || !zp->TestObecnosciZBS()) return;

	glPushMatrix();

	for(int indeks=0;indeks<zp->LiczbaBryl();++indeks)
	{		
		Prostopadloscian* prostopadloscian=(Prostopadloscian*)zp->PobierzBryleSztywna(indeks);
        Wektor polozenieProstopadloscianu=jednostkaDlugosci*prostopadloscian->PolozenieSrodkaMasy();
		Wektor rozmiarProstopadloscianu=jednostkaDlugosci*prostopadloscian->Rozmiar();
		
		double elementyMacierzyObrotuProstopadloscianu[16];
		prostopadloscian->MacierzObrotu().KopiaElementow4x4(elementyMacierzyObrotuProstopadloscianu);
		for(int i=0;i<16;++i) elementyMacierzyObrotuProstopadloscianu[i]*=jednostkaDlugosci;
  
        if(!koloruj) glColor4fv(prostopadloscian->Kolor());

		glPushMatrix();	
		glTranslated(polozenieProstopadloscianu.X,polozenieProstopadloscianu.Y,polozenieProstopadloscianu.Z); //translacja
		glMultMatrixd(elementyMacierzyObrotuProstopadloscianu); //obrot		
		Modele::RysujProstopadloscian((float)rozmiarProstopadloscianu.X,(float)rozmiarProstopadloscianu.Y,(float)rozmiarProstopadloscianu.Z,koloruj,false,NULL);
		glPopMatrix();						
    }

	glPopMatrix();
}

LRESULT CMojeOknoGL::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{	
	const int IDT_TIMER_OBLICZEN=1;
	const int IDT_TIMER_RYSOWANIA=2;

	long wynik=COknoGL::WndProc(hWnd,message,wParam,lParam);		

	switch (message)
	{
		case WM_CREATE: //pole uchwytOkna nie jest zainicjowane w WM_CREATE -> nalezy uzywac hWnd
			if (SetTimer(hWnd,IDT_TIMER_OBLICZEN,USER_TIMER_MINIMUM,NULL)==0)
				MessageBox(hWnd,"Nie udao si ustawi timera obliczen","",MB_OK | MB_ICONERROR);
			if (SetTimer(hWnd,IDT_TIMER_RYSOWANIA,50,NULL)==0)
				MessageBox(hWnd,"Nie udao si ustawi timera rysowania","",MB_OK | MB_ICONERROR);
			poprzedniCzas=GetTickCount();
			break;
		case WM_TIMER:
			if (pauza) break;
			switch(wParam)
			{
				case IDT_TIMER_OBLICZEN:
					if (zbs!=NULL)
						for(int i=0;i<iloscKrokowWSerii;i++) 
							zbs->KrokNaprzod(krokCzasowy,algorytm);					
					break;
				case IDT_TIMER_RYSOWANIA:
					RysujScene();
					break;
			}
			wynik=0;

			break;
		case WM_DESTROY:
			KillTimer(uchwytOkna,IDT_TIMER_OBLICZEN);
			KillTimer(uchwytOkna,IDT_TIMER_RYSOWANIA);
			break;

		case WM_KEYDOWN:
			bool wywolacRysujScene=true;
			switch(wParam)
			{
				case 'C':
					typRzutowania=!typRzutowania;
					UstawienieSceny(typRzutowania);
					break;
				case VK_SPACE:
					pauza=!pauza;
					wywolacRysujScene=false;
					break;
			}
			if (pauza && wywolacRysujScene) RysujScene();
			break;
	}
	
	return wynik;
}

void CMojeOknoGL::RysujAktorow()
{	
	const double jednostkaDlugosci=1;

	//srodek ukladu wspolrzednych
	glColor3f(0,0,0);
	glPointSize(1);
	glBegin(GL_POINTS);
	glVertex3f(0,0,0);
	glEnd();	

	RysujZbiorProstopadloscianow((ZbiorProstopadloscianow*)zbs,jednostkaDlugosci,true);
}

#pragma region Zrodla swiatla
//zrodla swiatla
void CMojeOknoGL::ZrodlaSwiatla()
{
	natezenie_swiatla_tla=0.5f;
	MlecznaZarowka(0.5f);
}


void CMojeOknoGL::MlecznaZarowka(float jasnosc)
{	
	const float kolor[4]={jasnosc,jasnosc,jasnosc,1.0f};
	const float pozycja[4]={5.0f,0.0f,5.0f,1.0f};	
	glLightfv(GL_LIGHT1,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor);
	glEnable(GL_LIGHT1);
}

void CMojeOknoGL::ZoltaIZielonaMleczneZarowki()
{
	//zolta mleczna zarowka
	const float kolor_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_zolta);
	//glEnable(GL_LIGHT2);

	//zielona mleczna zarowka
	const float kolor_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_zielony);
	//glEnable(GL_LIGHT3);
}

void CMojeOknoGL::Reflektor(float jasnoscRozblysk,float jasnoscRozproszone)
{
	const float kolor_rozproszone[4]={jasnoscRozproszone,jasnoscRozproszone,jasnoscRozproszone,1.0f};
	const float kolor_rozblysk[4]={jasnoscRozblysk,jasnoscRozblysk,jasnoscRozblysk,1.0};
	const float pozycja[4]={-10.0f,-10.0f,10.0f,1.0f};	
	const float kierunek[4]={1.0,1.0,-1.0,1.0};   
	const float szerokosc_wiazki=30.0f; //w stopniach
	const float wygaszanie=1.0f;
   
	glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);

	glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_rozblysk);
	glLightfv(GL_LIGHT4,GL_SPOT_DIRECTION,kierunek);
	glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
	glLightf(GL_LIGHT4,GL_SPOT_EXPONENT,wygaszanie);
	//glEnable(GL_LIGHT4);
}
#pragma endregion
